package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.integration.TicketServiceIntegration;
import com.bxm.adscounter.integration.meituan.MeituanIntegration;
import com.bxm.adscounter.integration.meituan.MeituanProperties;
import com.bxm.adscounter.integration.meituan.MeituanRequest;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.inads.event.AdLandpageClickImageEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAppExtend;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;

/**
 * @author allen
 * @date 2022-04-18
 * @since 1.0
 */
@Slf4j
//@Configuration
@Deprecated
public class MeituanOcpxReportOnAdLandpageClickImageEventListener implements EventListener<AdLandpageClickImageEvent> {

    private final Pair pair;
    private final Properties properties;
    private final MeituanIntegration meituanIntegration;
    private final MeituanProperties meituanProperties;
    private final TicketServiceIntegration ticketServiceIntegration;

    public MeituanOcpxReportOnAdLandpageClickImageEventListener(Pair pair, Properties properties, MeituanIntegration meituanIntegration, MeituanProperties meituanProperties, TicketServiceIntegration ticketServiceIntegration) {
        this.pair = pair;
        this.properties = properties;
        this.meituanIntegration = meituanIntegration;
        this.meituanProperties = meituanProperties;
        this.ticketServiceIntegration = ticketServiceIntegration;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdLandpageClickImageEvent event) {
        KeyValueMap map = event.getLog();
        String adid = map.getFirst(Inads.Param.ADID);

        if (!isReporting(adid)) {
            return;
        }

        String source = getSource(adid);
        if (StringUtils.isBlank(source)) {
            return;
        }

        MeituanRequest request = new MeituanRequest()
                .setSource(source)
                .setAppType(map.getFirst(Pangu.Param.OS))
                .setImeiMd5(map.getFirst(Pangu.Param.IMEI_MD5))
                .setIdfaMd5(map.getFirst(Pangu.Param.IDFA_MD5))
                .setOaid(map.getFirst(Pangu.Param.OAID))
                .setOaidMd5(map.getFirst(Pangu.Param.OAID_MD5));

        this.extend(map, request);

        meituanIntegration.report(request);
    }

    protected void extend(KeyValueMap keyValueMap, MeituanRequest request) {
        String adid = keyValueMap.getFirst(Pangu.Param.ADID);
        String bxmId = keyValueMap.getFirst(Pangu.Param.BXMID);

        request.setAdid(adid);
        request.setIp(keyValueMap.getIp());
        request.setAdxid(keyValueMap.getFirst(Pangu.Param.ADXID));
        request.setUa(keyValueMap.getUa());

        request.setReportUrl(meituanProperties.getReportClickUrl());
        request.addExtend("app", "group");
        request.addExtend("coderesp", "true");
        request.addExtend("mt_channel", "meituanunion");
        request.addExtend("action_time", TypeHelper.castToString(System.currentTimeMillis()));

        // 转化回调：有转化发生时，会调用渠道侧提供的回传链接(即点击上报链接中的feedback_url)，
        // 调用时会拼接上转化类型字段（event_type）,目前支持的转化类型如下，
        // 另外会拼接event_time字段，行为发生时间戳，单位毫秒
        String feedbackUrl = getFeedbackUrl(bxmId);
        request.setFeedbackUrl(UrlHelper.urlEncode(feedbackUrl));
    }

    private String getFeedbackUrl(String bxmId) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.putIfNotBlank(Inads.Param.BXMID, bxmId);
        map.putIfNotBlank(Inads.Param.CONVERSION_STATUS, "1");
        map.putIfNotBlank(Inads.Param.CONVERSION_TYPE, "1");
        return map.createOpenLogRequestUri(properties.getOpenLogRequestOutDomain());
    }

    private String getSource(String adid) {
        Ticket ticket = ticketServiceIntegration.get(TypeHelper.castToBigInteger(adid));
        TicketAppExtend appExtend = ticket.getAdTicketAppExtend();
        if (Objects.isNull(appExtend)) {
            return null;
        }
        String jumpUrl = appExtend.getJumpUrl();
        if (StringUtils.isBlank(jumpUrl)) {
            return null;
        }
        try {
            return UriComponentsBuilder.fromUriString(jumpUrl).build().getQueryParams().getFirst("lch");
        } catch (Exception e) {
            log.error("getSource: ", e);
            return null;
        }
    }

    private boolean isReporting(String adid) {
        return Optional.ofNullable(pair.get("meituan.ocpx.report.adid.list").ofHashSet()).orElse(new HashSet<>()).contains(adid);
    }
}
