package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.integration.yoqu.YoquIntegration;
import com.bxm.adscounter.integration.yoqu.YoquProperties;
import com.bxm.adscounter.integration.yoqu.YoquRequest;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.inads.event.AdLandpageClickImageEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.UrlHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

import java.util.HashSet;
import java.util.Optional;

/**
 * @author allen
 * @date 2022-04-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class YoquOcpxReportOnAdLandpageClickImageEventListener implements EventListener<AdLandpageClickImageEvent> {

    private final Pair pair;
    private final Properties properties;
    private final YoquIntegration yoquIntegration;
    private final YoquProperties yoquProperties;

    public YoquOcpxReportOnAdLandpageClickImageEventListener(Pair pair, Properties properties, YoquIntegration yoquIntegration,
                                                             YoquProperties yoquProperties) {
        this.pair = pair;
        this.properties = properties;
        this.yoquIntegration = yoquIntegration;
        this.yoquProperties = yoquProperties;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdLandpageClickImageEvent event) {
        KeyValueMap map = event.getLog();
        String adid = map.getFirst(Inads.Param.ADID);
        String bxmId = map.getFirst(Pangu.Param.BXMID);

        if (!isReporting(adid)) {
            return;
        }

        String os = map.getFirst(Inads.Param.OS);

        String feedbackUrl = getFeedbackUrl(bxmId);

        YoquRequest request = YoquRequest.builder()
                .adAgent(yoquProperties.getAdAgent())
                .callbackUrl(UrlHelper.urlEncode(feedbackUrl))
                .chainCode(yoquProperties.getChainCode())
                .channel(yoquProperties.getChannel())
                .eventType(YoquRequest.EVENT_TYPE_CLICK)
                .idfa(map.getFirst(Pangu.Param.IDFA))
                .idfaMd5(map.getFirst(Pangu.Param.IDFA_MD5))
                .imei(map.getFirst(Pangu.Param.IMEI))
                .imeiMd5(map.getFirst(Pangu.Param.IMEI_MD5))
                .oaid(map.getFirst(Pangu.Param.OAID))
                .oaidMd5(map.getFirst(Pangu.Param.OAID_MD5))
                .os(StringUtils.equalsIgnoreCase(os, "1") ? "0"
                        : StringUtils.equalsIgnoreCase(os, "2") ? "1"
                        : "3")
                .adid(yoquProperties.getAdid())
                .advertisingSpaceId(yoquProperties.getAdvertisingSpaceId())
                .taskId(yoquProperties.getTaskId())
                .panguAdid(adid)
                .ip(map.getFirst(Pangu.Param.IP))
                .build();

        yoquIntegration.report(request);
    }

    private String getFeedbackUrl(String bxmId) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.INADS);
        map.setMt(Inads.Mt.AdConversion.original());
        map.putIfNotBlank(Inads.Param.BXMID, bxmId);
        map.putIfNotBlank(Inads.Param.CONVERSION_STATUS, "1");
        map.putIfNotBlank(Inads.Param.CONVERSION_TYPE, "1");
        return map.createOpenLogRequestUri(properties.getOpenLogRequestOutDomain());
    }

    private boolean isReporting(String adid) {
        return Optional.ofNullable(pair.get("yoqu.ocpx.report.adid.list").ofHashSet()).orElse(new HashSet<>()).contains(adid);
    }
}
