package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.BigoFeedbackService;
import com.bxm.adscounter.rtb.common.service.XiaomiFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-07-05
 * @since 1.0
 */
@Slf4j
@Configuration
public class BigoFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final BigoFeedbackService bigoFeedbackService;


    public BigoFeedbackActivityAttendEventListener(BigoFeedbackService bigoFeedbackService) {
        this.bigoFeedbackService = bigoFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            bigoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("bigo feedback: ", e);
        }
    }
}
