package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.BilibiliFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-08-26
 * @since 1.0
 */
@Slf4j
@Configuration
public class BilibiliFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final BilibiliFeedbackService bilibiliFeedbackService;

    public BilibiliFeedbackActivityAttendEventListener(BilibiliFeedbackService bilibiliFeedbackService) {
        this.bilibiliFeedbackService = bilibiliFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            bilibiliFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("bilibili feedback: ", e);
        }
    }
}
