package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.JiGuangAdxFeedbackService;
import com.bxm.adscounter.rtb.common.service.JiGuangFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
@Configuration
public class JiguangAdxFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final JiGuangAdxFeedbackService jiGuangAdxFeedbackService;

    public JiguangAdxFeedbackActivityAttendEventListener(JiGuangAdxFeedbackService jiGuangAdxFeedbackService) {
        this.jiGuangAdxFeedbackService = jiGuangAdxFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            jiGuangAdxFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("jiguangadx feedback: ", e);
        }
    }
}
