package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.KuaiKanFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-11-14
 * @since 1.0
 */
@Slf4j
@Configuration
public class KuaiKanFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final KuaiKanFeedbackService kuaiKanFeedbackService;

    public KuaiKanFeedbackActivityAttendEventListener(KuaiKanFeedbackService kuaiKanFeedbackService) {
        this.kuaiKanFeedbackService = kuaiKanFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            kuaiKanFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("kuaikan feedback: ", e);
        }
    }
}
