package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.MintegralFeedbackService;
import com.bxm.adscounter.rtb.common.service.OppoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-08-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class MintegralFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final MintegralFeedbackService mintegralFeedbackService;

    public MintegralFeedbackActivityAttendEventListener(MintegralFeedbackService mintegralFeedbackService) {
        this.mintegralFeedbackService = mintegralFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            mintegralFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("mintegral feedback: ", e);
        }
    }
}
