package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.QttFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-20
 * @since 1.0
 */
@Slf4j
@Configuration
public class QttFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final QttFeedbackService qttFeedbackService;

    public QttFeedbackActivityAttendEventListener(QttFeedbackService qttFeedbackService) {
        this.qttFeedbackService = qttFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            qttFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("qtt feedback: ", e);
        }
    }
}
