package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.SigmobDspFeedbackService;
import com.bxm.adscounter.rtb.common.service.SigmobInadsFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-11-24
 * @since 1.0
 */
@Slf4j
@Configuration
public class SigmobInadsFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final SigmobInadsFeedbackService sigmobInadsFeedbackService;

    public SigmobInadsFeedbackActivityAttendEventListener(SigmobInadsFeedbackService sigmobInadsFeedbackService) {
        this.sigmobInadsFeedbackService = sigmobInadsFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            sigmobInadsFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("Sigmobinads feedback: ", e);
        }
    }
}
