package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.TencentFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 *  腾讯广点通
 * @author daill
 * @date 2022-05-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class TencentActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final TencentFeedbackService tencentFeedbackService;

    public TencentActivityAttendEventListener(TencentFeedbackService tencentFeedbackService) {
        this.tencentFeedbackService = tencentFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            tencentFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("tencent feedback: ", e);
        }
    }
}
