package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.BaiduFeedbackService;
import com.bxm.adscounter.rtb.common.service.UCFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class UcFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final UCFeedbackService ucFeedbackService;

    public UcFeedbackActivityAttendEventListener(UCFeedbackService ucFeedbackService) {
        this.ucFeedbackService = ucFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            ucFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("Uc feedback: ", e);
        }
    }
}
