package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.UCFeedbackService;
import com.bxm.adscounter.rtb.common.service.WyydFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class WyydFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final WyydFeedbackService wyydFeedbackService;

    public WyydFeedbackActivityAttendEventListener(WyydFeedbackService wyydFeedbackService) {
        this.wyydFeedbackService = wyydFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            wyydFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("wyyd feedback: ", e);
        }
    }
}
