package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.XiaomiFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
@Configuration
public class XiaomiFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final XiaomiFeedbackService xiaomiFeedbackService;

    public XiaomiFeedbackActivityAttendEventListener(XiaomiFeedbackService xiaomiFeedbackService) {
        this.xiaomiFeedbackService = xiaomiFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            xiaomiFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("xiaomi feedback: ", e);
        }
    }
}
