package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.QiMaoFeedbackService;
import com.bxm.adscounter.rtb.common.service.XunFeiFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-10-17
 * @since 1.0
 */
@Slf4j
@Configuration
public class XunFeiFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final XunFeiFeedbackService xunFeiFeedbackService;

    public XunFeiFeedbackActivityAttendEventListener(XunFeiFeedbackService xunFeiFeedbackService) {
        this.xunFeiFeedbackService = xunFeiFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            xunFeiFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("xunfei feedback: ", e);
        }
    }
}
