package com.bxm.adscounter.service.openlog.inads.listener.activity.attend;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.SouHuFeedbackService;
import com.bxm.adscounter.rtb.common.service.YiXiaoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.ActivityAttendEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-09-06
 * @since 1.0
 */
@Slf4j
@Configuration
public class YiXiaoFeedbackActivityAttendEventListener implements EventListener<ActivityAttendEvent> {

    private final YiXiaoFeedbackService yiXiaoFeedbackService;

    public YiXiaoFeedbackActivityAttendEventListener(YiXiaoFeedbackService yiXiaoFeedbackService) {
        this.yiXiaoFeedbackService = yiXiaoFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityAttendEvent event) {
        try {
            yiXiaoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("yixiao feedback: ", e);
        }
    }
}
