package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.BaiduFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class BaiduFeedbackAdClickEventListener implements EventListener<AdClickEvent> {

    private final BaiduFeedbackService baiduFeedbackService;

    public BaiduFeedbackAdClickEventListener(BaiduFeedbackService baiduFeedbackService) {
        this.baiduFeedbackService = baiduFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            baiduFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("baidu feedback: ", e);
        }
    }
}
