package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.JiGuangFeedbackService;
import com.bxm.adscounter.rtb.common.service.UCFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-19
 * @since 1.0
 */
@Slf4j
@Configuration
public class JiguangFeedbackAdClickEventListener implements EventListener<AdClickEvent> {
    private final JiGuangFeedbackService jiGuangFeedbackService;

    public JiguangFeedbackAdClickEventListener(JiGuangFeedbackService jiGuangFeedbackService) {
        this.jiGuangFeedbackService = jiGuangFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            jiGuangFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("Jiguang feedback: ", e);
        }
    }
}
