package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.OppoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-07-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class OppoFeedbackAdClickEventListener implements EventListener<AdClickEvent> {

    private final OppoFeedbackService oppoFeedbackService;

    public OppoFeedbackAdClickEventListener(OppoFeedbackService oppoFeedbackService) {
        this.oppoFeedbackService = oppoFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            oppoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("oppo feedback: ", e);
        }
    }
}
