package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.adscounter.service.reporting.ReportingConfig;
import com.bxm.adscounter.service.reporting.ReportingConfigurer;
import com.bxm.adscounter.service.reporting.ReportingSender;
import com.bxm.adscounter.service.reporting.ReportingSenderFactory;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
@Slf4j
@Configuration
public class ReportingAdClickEventListener implements EventListener<AdClickEvent> {

    private final ReportingConfigurer reportingConfigurer;
    private final ReportingSenderFactory senderFactory;

    public ReportingAdClickEventListener(ReportingConfigurer reportingConfigurer, ReportingSenderFactory senderFactory) {
        this.reportingConfigurer = reportingConfigurer;
        this.senderFactory = senderFactory;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        KeyValueMap map = event.getLog();
        String adid = map.getFirst(Inads.Param.ADID);
        ReportingConfig config = reportingConfigurer.get(adid);
        if (Objects.isNull(config)) {
            return;
        }
        String type = config.getType();
        ReportingSender sender = senderFactory.get(type);
        if (Objects.isNull(sender)) {
            log.warn("No bean found for type: {}", type);
            return;
        }
        sender.send(config.getReportUrl(), map);
    }
}
