package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.SigmobDspFeedbackService;
import com.bxm.adscounter.rtb.common.service.SigmobInadsFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-11-24
 * @since 1.0
 */
@Slf4j
@Configuration
public class SigmobInadsFeedbackAdClickEventListener implements EventListener<AdClickEvent> {
    private final SigmobInadsFeedbackService sigmobInadsFeedbackService;

    public SigmobInadsFeedbackAdClickEventListener(SigmobInadsFeedbackService sigmobInadsFeedbackService) {
        this.sigmobInadsFeedbackService = sigmobInadsFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            sigmobInadsFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("sigmobinads feedback: ", e);
        }
    }
}
