package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.control.ratio.AbstractSmartConversionIntegration;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.google.common.collect.Sets;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * 广告券点击监听器，作用在智能回传。
 *
 * @author allen
 * @date 2022-10-18
 * @since 1.0
 */
@Configuration
public class SmartConversionAdClickEventListener extends AbstractSmartConversionIntegration implements EventListener<AdClickEvent> {

    public SmartConversionAdClickEventListener(PositionRtbService positionRtbService,
                                               RtbIntegrationFactory rtbIntegrationFactory,
                                               RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(positionRtbService, rtbIntegrationFactory, ratioControlRtbIntegration);
    }

    @Override
    protected Set<Rtb> includes() {
        return Sets.newHashSet();
    }

    @Override
    protected Set<Rtb> excludes() {
        return Sets.newHashSet(Rtb.Kuaishou);
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        KeyValueMap eventLog = event.getLog();
        super.doTicketClick(eventLog);
    }
}
