package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.VivoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-06-21
 * @since 1.0
 */
@Slf4j
@Configuration
public class VivoFeedbackAdClickEventListener implements EventListener<AdClickEvent> {
    private final VivoFeedbackService vivoFeedbackService;

    public VivoFeedbackAdClickEventListener(VivoFeedbackService vivoFeedbackService) {
        this.vivoFeedbackService = vivoFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            vivoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("vivo feedback: ", e);
        }
    }
}
