package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.WIFIFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-06-27
 * @since 1.0
 */
@Slf4j
@Configuration
public class WifiFeedbackAdClickEventListener implements EventListener<AdClickEvent> {
    private final WIFIFeedbackService wifiFeedbackService;

    public WifiFeedbackAdClickEventListener(WIFIFeedbackService wifiFeedbackService) {
        this.wifiFeedbackService = wifiFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            wifiFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("wifi feedback: ", e);
        }
    }
}
