package com.bxm.adscounter.service.openlog.inads.listener.ad.click;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.XiaomiFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
@Configuration
public class XiaomiFeedbackAdClickEventListener implements EventListener<AdClickEvent> {
    private final XiaomiFeedbackService xiaomiFeedbackService;

    public XiaomiFeedbackAdClickEventListener(XiaomiFeedbackService xiaomiFeedbackService) {
        this.xiaomiFeedbackService = xiaomiFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdClickEvent event) {
        try {
            xiaomiFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("xiaomi feedback: ", e);
        }
    }
}
