package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.AlipayLifeFeedbackService;
import com.bxm.adscounter.rtb.common.service.UCFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class AlipayLifeFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final AlipayLifeFeedbackService alipayLifeFeedbackService;

    public AlipayLifeFeedbackAdConversionEventListener(AlipayLifeFeedbackService alipayLifeFeedbackService) {
        this.alipayLifeFeedbackService = alipayLifeFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            alipayLifeFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("AlipayLife feedback: ", e);
        }
    }
}
