package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.BigoFeedbackService;
import com.bxm.adscounter.rtb.common.service.XiaomiFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-07-05
 * @since 1.0
 */
@Slf4j
@Configuration
public class BigoFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final BigoFeedbackService bigoFeedbackService;

    public BigoFeedbackAdConversionEventListener(BigoFeedbackService bigoFeedbackService) {
        this.bigoFeedbackService = bigoFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            bigoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("bigo feedback: ", e);
        }
    }
}
