package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.BxmFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-11-29
 * @since 1.0
 */
@Slf4j
@Configuration
public class BxmFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final BxmFeedbackService bxmFeedbackService;

    public BxmFeedbackAdConversionEventListener(BxmFeedbackService bxmFeedbackService) {
        this.bxmFeedbackService = bxmFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            bxmFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("bxm feedback: ", e);
        }
    }
}
