package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.DomobFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-08-02
 * @since 1.0
 */
@Slf4j
@Configuration
public class DomobFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final DomobFeedbackService domobFeedbackService;

    public DomobFeedbackAdConversionEventListener(DomobFeedbackService domobFeedbackService) {
        this.domobFeedbackService = domobFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            domobFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("domob feedback: ", e);
        }
    }
}
