package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.HimalayanFeedbackService;
import com.bxm.adscounter.rtb.common.service.WyydFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class HimalayanFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final HimalayanFeedbackService himalayanFeedbackService;

    public HimalayanFeedbackAdConversionEventListener(HimalayanFeedbackService himalayanFeedbackService) {
        this.himalayanFeedbackService = himalayanFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            himalayanFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("himalayan feedback: ", e);
        }
    }
}
