package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.JiGuangAdxFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-06-01
 * @since 1.0
 */
@Slf4j
@Configuration
public class JiguangAdxFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final JiGuangAdxFeedbackService jiGuangAdxFeedbackService;

    public JiguangAdxFeedbackAdConversionEventListener(JiGuangAdxFeedbackService jiGuangAdxFeedbackService) {
        this.jiGuangAdxFeedbackService = jiGuangAdxFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            jiGuangAdxFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("Jiguang adx feedback: ", e);
        }
    }
}
