package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.KuaiKanFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-11-14
 * @since 1.0
 */
@Slf4j
@Configuration
public class KuaiKanFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final KuaiKanFeedbackService kuaiKanFeedbackService;

    public KuaiKanFeedbackAdConversionEventListener(KuaiKanFeedbackService kuaiKanFeedbackService) {
        this.kuaiKanFeedbackService = kuaiKanFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            kuaiKanFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("iqiyi feedback: ", e);
        }
    }
}
