package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.OceanEngineFeedbackService;
import com.bxm.adscounter.rtb.common.service.UCFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-05-16
 * @since 1.0
 */
@Slf4j
@Configuration
public class OceanEngineFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final OceanEngineFeedbackService oceanEngineFeedbackService;

    public OceanEngineFeedbackAdConversionEventListener(OceanEngineFeedbackService oceanEngineFeedbackService) {
        this.oceanEngineFeedbackService = oceanEngineFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            oceanEngineFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("oceanEngine feedback: ", e);
        }
    }
}
