package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.QiMaoFeedbackService;
import com.bxm.adscounter.rtb.common.service.YiXiaoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-10-17
 * @since 1.0
 */
@Slf4j
@Configuration
public class QiMaoFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final QiMaoFeedbackService qiMaoFeedbackService;


    public QiMaoFeedbackAdConversionEventListener(QiMaoFeedbackService qiMaoFeedbackService) {
        this.qiMaoFeedbackService = qiMaoFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            qiMaoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("qimao  feedback: ", e);
        }
    }
}
