package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.RuishiFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-08-30
 * @since 1.0
 */
@Slf4j
@Configuration
public class RuishiFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final RuishiFeedbackService ruishiFeedbackService;

    public RuishiFeedbackAdConversionEventListener(RuishiFeedbackService ruishiFeedbackService) {
        this.ruishiFeedbackService = ruishiFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            ruishiFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("ruishi feedback: ", e);
        }
    }
}
