package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.SigmobDspFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-07-25
 * @since 1.0
 */
@Slf4j
@Configuration
public class SigmobDspFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final SigmobDspFeedbackService sigmobFeedbackService;

    public SigmobDspFeedbackAdConversionEventListener(SigmobDspFeedbackService sigmobFeedbackService) {
        this.sigmobFeedbackService = sigmobFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            sigmobFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("sigmobdsp feedback: ", e);
        }
    }
}
