package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.SigmobDspFeedbackService;
import com.bxm.adscounter.rtb.common.service.SigmobInadsFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-11-24
 *
 * @since 1.0
 */
@Slf4j
@Configuration
public class SigmobInadsFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final SigmobInadsFeedbackService sigmobInadsFeedbackService;

    public SigmobInadsFeedbackAdConversionEventListener(SigmobInadsFeedbackService sigmobInadsFeedbackService) {
        this.sigmobInadsFeedbackService = sigmobInadsFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            sigmobInadsFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("sigmobinads feedback: ", e);
        }
    }
}
