package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.AdbeeFeedbackService;
import com.bxm.adscounter.rtb.common.service.SouHuFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-09-05
 * @since 1.0
 */
@Slf4j
@Configuration
public class SouHuFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final SouHuFeedbackService souHuFeedbackService;


    public SouHuFeedbackAdConversionEventListener(SouHuFeedbackService souHuFeedbackService) {
        this.souHuFeedbackService = souHuFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            souHuFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("suhu  feedback: ", e);
        }
    }
}
