package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.WeiBoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-06-27
 * @since 1.0
 */
@Slf4j
@Configuration
public class WeiBoFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final WeiBoFeedbackService weiBoFeedbackService;

    public WeiBoFeedbackAdConversionEventListener(WeiBoFeedbackService weiBoFeedbackService) {
        this.weiBoFeedbackService = weiBoFeedbackService;
    }


    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            weiBoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("weibo feedback: ", e);
        }
    }
}
