package com.bxm.adscounter.service.openlog.inads.listener.ad.conversion;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.service.SouHuFeedbackService;
import com.bxm.adscounter.rtb.common.service.YiXiaoFeedbackService;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author daill
 * @date 2022-09-06
 * @since 1.0
 */
@Slf4j
@Configuration
public class YiXiaoFeedbackAdConversionEventListener implements EventListener<AdConversionEvent> {

    private final YiXiaoFeedbackService yiXiaoFeedbackService;


    public YiXiaoFeedbackAdConversionEventListener(YiXiaoFeedbackService yiXiaoFeedbackService) {
        this.yiXiaoFeedbackService = yiXiaoFeedbackService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(AdConversionEvent event) {
        try {
            yiXiaoFeedbackService.doFeedback(event.getLog());
        } catch (RtbIntegrationException e) {
            log.error("yixiao  feedback: ", e);
        }
    }
}
