package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.baidu.BaiduRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-10-24
 * @since 1.0
 */
@Slf4j
@Configuration
public class BaiduIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    public BaiduIndexShowEventListener(BaiduRtbIntegration baiduRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(baiduRtbIntegration, ratioControlRtbIntegration);
    }

    @Override
    protected String getClickIdNameOnExt() {
        return BaiduRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return BaiduRtbIntegration.AD_GROUP_ID;
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
