package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.bilibili.BilibiliRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-11-11
 * @since 1.0
 */
@Slf4j
@Configuration
public class BiliBiliIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    public BiliBiliIndexShowEventListener(BilibiliRtbIntegration bilibiliRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(bilibiliRtbIntegration, ratioControlRtbIntegration);
    }

    @Override
    protected String getClickIdNameOnExt() {
        return BilibiliRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return BilibiliRtbIntegration.AD_GROUP_ID;
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
