package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.xmly.HimalayanRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-07-27
 * @since 1.0
 */
@Slf4j
@Configuration
public class HimalayaIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    public HimalayaIndexShowEventListener(HimalayanRtbIntegration himalayanRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(himalayanRtbIntegration, ratioControlRtbIntegration);
    }

    @Override
    protected String getClickIdNameOnExt() {
        return HimalayanRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return null;
    }

    @Override
    protected String getAdGroupIdValue(KeyValueMap keyValueMap, JSONObject ext) {
        String callback = ext.getString(getClickIdNameOnExt());
        if (StringUtils.isNotBlank(callback)) {
            return UrlHelper.getFirstValueOfParamName(callback, HimalayanRtbIntegration.AD_GROUP_ID);
        }
        return null;
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
