package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.mintegral.MintegralRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-08-19
 * @since 1.0
 */
@Slf4j
@Configuration
public class MintegralIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    private final MintegralRtbIntegration mintegralRtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public MintegralIndexShowEventListener(MintegralRtbIntegration mintegralRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(mintegralRtbIntegration, ratioControlRtbIntegration);
        this.mintegralRtbIntegration = mintegralRtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    @Override
    protected String getClickIdNameOnExt() {
        return "clickid";
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return "campuuid";
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
