package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.oppo.OppoRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-08-18
 * @since 1.0
 */
@Slf4j
@Configuration
public class OppoIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    private final OppoRtbIntegration oppoRtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public OppoIndexShowEventListener(OppoRtbIntegration oppoRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(oppoRtbIntegration, ratioControlRtbIntegration);
        this.oppoRtbIntegration = oppoRtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    @Override
    protected String getClickIdNameOnExt() {
        return OppoRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return null;
    }

    @Override
    protected String getAdGroupIdValue(KeyValueMap keyValueMap, JSONObject ext) {
        String transparent = ext.getString("transparent");
        return oppoRtbIntegration.getAdGroupIdForTransparent(transparent);
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
