package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.bilibili.BilibiliRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.sigmobinads.SigmobInadsRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author tangxiao
 * @date 2022-11-24
 * @since 1.0
 */
@Slf4j
@Configuration
public class SigmobInadsIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    public SigmobInadsIndexShowEventListener(SigmobInadsRtbIntegration sigmobInadsRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(sigmobInadsRtbIntegration, ratioControlRtbIntegration);
    }

    @Override
    protected String getClickIdNameOnExt() {
        return SigmobInadsRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return SigmobInadsRtbIntegration.AD_GROUP_ID;
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
