package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.uc.UcRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.context.annotation.Configuration;

/**
 * Uc 浏览器中间页曝光监听器
 *
 * @author allen
 * @date 2022-11-29
 * @since 1.0
 */
@Configuration
public class UcIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    public UcIndexShowEventListener(UcRtbIntegration rtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(rtbIntegration, ratioControlRtbIntegration);
    }

    @Override
    protected String getClickIdNameOnExt() {
        return UcRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return UcRtbIntegration.AD_GROUP_ID;
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
