package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.weibo.WeiBoRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-09-19
 * @since 1.0
 */
@Slf4j
@Configuration
public class WeiboIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    private final WeiBoRtbIntegration weiboRtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public WeiboIndexShowEventListener(WeiBoRtbIntegration weiboRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(weiboRtbIntegration, ratioControlRtbIntegration);
        this.weiboRtbIntegration = weiboRtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    @Override
    protected String getClickIdNameOnExt() {
        return WeiBoRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return null;
    }

    @Override
    protected String getAdGroupIdValue(KeyValueMap keyValueMap, JSONObject ext) {
        return keyValueMap.getFirst(Inads.Param.TAGID);
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
