package com.bxm.adscounter.service.openlog.inads.listener.index;

import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.impl.xiaomi.XiaomiRtbIntegration;
import com.bxm.adscounter.service.openlog.inads.event.IndexShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

/**
 * @author allen
 * @date 2022-09-19
 * @since 1.0
 */
@Slf4j
@Configuration
public class XiaomiIndexShowEventListener extends AbstractSmartControlIndexShowEventListener implements EventListener<IndexShowEvent> {

    private final XiaomiRtbIntegration xiaomiRtbIntegration;
    private final RatioControlRtbIntegration ratioControlRtbIntegration;

    public XiaomiIndexShowEventListener(XiaomiRtbIntegration oppoRtbIntegration, RatioControlRtbIntegration ratioControlRtbIntegration) {
        super(oppoRtbIntegration, ratioControlRtbIntegration);
        this.xiaomiRtbIntegration = oppoRtbIntegration;
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
    }

    @Override
    protected String getClickIdNameOnExt() {
        return XiaomiRtbIntegration.CLICK_ID;
    }

    @Override
    protected String getAdGroupIdNameOnExt() {
        return "adid";
    }

    @Override
    protected String getApp(IndexShowEvent event) {
        return null;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(IndexShowEvent event) {
        super.consume(event);
    }
}
