package com.bxm.adscounter.service.openlog.pangu;

import com.bxm.adscounter.service.openlog.pangu.event.PanguAdClickEvent;
import com.bxm.adscounter.service.openlog.pangu.event.PanguAdShowEvent;
import com.bxm.adscounter.service.openlog.pangu.event.PanguAdWinEvent;
import com.bxm.adscounter.service.openlog.pangu.event.PanguArithmeticAllLogEvent;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventBusBean;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEventConfig;
import com.bxm.warcar.integration.eventbus.EventPark;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

import java.util.Collection;

/**
 * @author allen
 * @date 2022-05-09
 * @since 1.0
 */
@Configuration
public class DefaultPanguOpenLogEventBusBean implements OpenLogEventBusBean {

    private final EventPark eventPark;

    public DefaultPanguOpenLogEventBusBean(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Override
    public String getId() {
        return "ADSCOUNTER";
    }

    @Override
    public Production getProduction() {
        return Production.PANGU;
    }

    @Override
    public EventPark getEventPark() {
        return eventPark;
    }

    @Override
    public void bindTo(Collection<OpenLogEventConfig> registry) {
        registry.add(OpenLogEventConfig.builder().condition(e -> NumberUtils.toInt(e.getVersion(), 0) > 2).mt(Pangu.Mt.Show.original()).eventType(PanguAdShowEvent.class).build());
        registry.add(OpenLogEventConfig.builder().condition(e -> NumberUtils.toInt(e.getVersion(), 0) > 2).mt(Pangu.Mt.Click.original()).eventType(PanguAdClickEvent.class).build());
        registry.add(OpenLogEventConfig.builder().condition(e -> NumberUtils.toInt(e.getVersion(), 0) > 2).mt(Pangu.Mt.Win.original()).eventType(PanguAdWinEvent.class).build());
        registry.add(OpenLogEventConfig.builder().condition(e -> NumberUtils.toInt(e.getVersion(), 0) > 2).mt(Pangu.Mt.ArithmeticAllLog.original()).eventType(PanguArithmeticAllLogEvent.class).build());
    }
}
