package com.bxm.adscounter.service.openlog.pangu.listener;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.pangu.event.PanguAdClickEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.Constants;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.context.annotation.Configuration;

/**
 * 盘古的广告点击事件，转发盘古的胜出事件。
 *
 * @author allen
 * @date 2022-01-10
 * @since 1.0
 */
@Slf4j
@Configuration
public class PanguAdClick2WinEventListener implements EventListener<PanguAdClickEvent> {

    private final Properties properties;
    private final OpenLogClient openLogClient;

    public PanguAdClick2WinEventListener(Properties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(PanguAdClickEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        Constants.Adx adx = Constants.Adx.of(NumberUtils.toInt(keyValueMap.getFirst(Pangu.Param.ADXID)));
        switch (adx) {
            case Bes:
            case Bxm:
            case Kuaishou:
            case Domob:
            case Iflytek:
            case QTT:
            case OPPO:
            case XM:
            case YouJing:
            case AdMobile:
            case MeiTuan:
            default:
                int chargeType = NumberUtils.toInt(keyValueMap.getFirst(Pangu.Param.CHGTYPE), Pangu.Param.CHGTYPE_CPM);
                if (chargeType == Pangu.Param.CHGTYPE_CPC) {
                    sendWinLog(keyValueMap);
                }
                break;
        }
    }

    private void sendWinLog(KeyValueMap keyValueMap) {
        KeyValueMap customizedParams = new KeyValueMap();
        customizedParams.add(Pangu.Param.MT, Pangu.Mt.Win.original());
        customizedParams.add(Pangu.Param.VER, "3");
        String uri = keyValueMap.createOpenLogRequestUri(properties.getOpenLogRequestDomain(), customizedParams, true);
        openLogClient.asyncRequest(uri);
    }
}
